********************************************************************************
************************* Start and end variables ******************************
******************************* Chapter 5.3  ***********************************

*     Setting up globals so that it is easier to reference in code, replace with your file path
global working "My file path:\...\CPRD data\Stata files\Working\"


***************** Step 1: Import patient file **********************************
*     This is the formatted patient file in Chapter 5.1
use "$working\patients.dta"




***************** Step 2: Merge with practice file *****************************
*     This is the practice file in Chapter 5.2
merge m:1 pracid using "$working\practice.dta"

*     Let's check if the merge is successful
browse

*     Drop _merge==2, those that are in the using data and are not matched. (We are dropping practice)
drop if _merge==2

*     Dropping uneccesary variables
drop _merge





***************** Step 3: Creating start and end variables *********************
*     Create a pseudo 18th birth date. 
gen date18 = mdy(7,1,yob)

*     Creating Start date. This is the last of registration start date, pseudo 18th Birthday and start of the study.
gen start = max(regstartdate, date18, date("1/1/2004", "DMY"))

*     Creating End date. This is the first of date of death, registration end date, CPRD death date and end of the study.
gen end = min(emis_ddate, regenddate, cprd_ddate, date("7/10/2022", "DMY"))


***************** Step 4: Save in working folder *******************************
save "$working\patient_and_practice.dta"